<?php
 
include_once 'conexao.php';
   
class ModeloFiliado  
{    
	static public function mdlAddFiliado($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO filiado
						(idVaga, idUsuario, dataCadastro) VALUES 
						(:idVaga, :idUsuario, :dataCadastro)");
		
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
		
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}
 
	static public function mdlMostrarFiliadoPoridVagaEIdUsuario($idVaga, $idUsuario) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM filiado where idVaga = :idVaga and idUsuario = :idUsuario");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 
	static public function mdlMostrarVagasQueUsuarioEstaFiliadoPorIdUsuario($idUsuario) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM filiado where idUsuario = :idUsuario");
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarFiliadoPorIdFiliado($idFiliado) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM filiado where idFiliado = :idFiliado");
			$stmt->bindParam(":idFiliado", $idFiliado, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarFiliadoPorIdVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM filiado where idVaga = :idVaga");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
  

	static public function mdlMostrarMinhasVagasPorIdUsurario($idRecrutador) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where idRecrutador = :idRecrutador");
			$stmt->bindParam(":idRecrutador", $idRecrutador, PDO::PARAM_STR);
			$stmt ->execute();
			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarVagasPorCategoriaDaVaga($tipoVaga) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where tipoVaga = :tipoVaga");
			$stmt->bindParam(":tipoVaga", $tipoVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasVagas() {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga ");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlEditarPrecoDoCertificadoPorIdVaga($idVaga, $precoCertificado){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET precoCertificado = :precoCertificado where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":precoCertificado", $precoCertificado, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEditarModeloDoCertificadoPorIdVaga($idVaga, $idModeloCertificado){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET idModeloCertificado = :idModeloCertificado where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":idModeloCertificado", $idModeloCertificado, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEliminarLikeDoEventoPorIdLike($id, $idUsuario){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM eventolikes where idEvento = :id and idUsuario = :idUsuario");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>